const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
#define vec2 float2
#define vec3 float3
#define vec4 float4

vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc).zyxw;
}

vec4 INPUT(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, tc).zyxw;
}

				
__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2,
					__read_only image2d_t input3,__read_only image2d_t input4,
					__read_only image2d_t input5,__read_only image2d_t input6,
					__write_only image2d_t dstImg,
					__global FilterParam* param,
					int strength)
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	float saturateMatrix[9] = {
                            1.105150f,
                            -0.044850f,
                            -0.046000f,
                            -0.088050f,
                            1.061950f,
                            -0.089200f,
                            -0.017100f,
                            -0.017100f,
                            1.132900f };
	vec3 luma = (vec3)(.3f, .59f, .11f);	

	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 tc = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/resolution.xy;
	
	vec4 orig = INPUTSRC(input1, param, tc);
	vec3 texel = orig.xyz;
          	     
     vec2 lookup;
     lookup.y = 0.5f;
     lookup.x = texel.x;
     texel.x = INPUT(input2, lookup).x;
     lookup.x = texel.y;
     texel.y = INPUT(input2, lookup).y;
     lookup.x = texel.z;
     texel.z = INPUT(input2, lookup).z;
 
     texel.x = dot((vec3)(saturateMatrix[0], saturateMatrix[3],saturateMatrix[6]), texel);
     texel.y = dot((vec3)(saturateMatrix[1], saturateMatrix[4],saturateMatrix[7]), texel);
	 texel.z = dot((vec3)(saturateMatrix[2], saturateMatrix[5],saturateMatrix[8]), texel);
      
     vec2 tt = (2.0f * tc) - 1.0f;
     float d = dot(tt, tt);
     vec3 sampled;
	 
     lookup.y = 0.5f;
	 
     lookup.x = texel.x;
     sampled.x = INPUT(input3, lookup).x;
     lookup.x = texel.y;
     sampled.y = INPUT(input3, lookup).y;
     lookup.x = texel.z;
     sampled.z = INPUT(input3, lookup).z;
	 
     float value = smoothstep(0.0f, 1.0f, d);

     texel = mix(sampled, texel, value);
	 

     lookup.x = texel.x;
     texel.x = INPUT(input4, lookup).x;
     lookup.x = texel.y;
     texel.y = INPUT(input4, lookup).y;
     lookup.x = texel.z;
     texel.z = INPUT(input4, lookup).z;
	
     lookup.x = dot(texel, luma);
	 
     texel = mix(INPUT(input5, lookup).xyz, texel, .5f);
     lookup.x = texel.x;
     texel.x = INPUT(input6, lookup).x;
     lookup.x = texel.y;
     texel.y = INPUT(input6, lookup).y;
     lookup.x = texel.z;
     texel.z = INPUT(input6, lookup).z;
	vec4 outputCol = mix((vec4)(texel.zyx, orig.w), orig, (vec4)(1.0f - (float)strength/100.0f)); 
     write_imagef(dstImg, (int2)(w, h), outputCol); 
}